/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.permissions;

import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.events.ImpactorEvent;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.platform.plugins.PluginMetadata;
import net.impactdev.impactor.api.services.permissions.PermissionsService;
import net.impactdev.impactor.api.services.permissions.SuggestPermissionServiceEvent;
import net.impactdev.impactor.core.modules.ImpactorModule;
import net.impactdev.impactor.core.permissions.LuckPermsPermissionsService;
import net.impactdev.impactor.core.permissions.NoOpPermissionsService;
import net.impactdev.impactor.core.permissions.register.PermissionsRegistrationProvider;
import net.impactdev.impactor.core.permissions.register.SuggestPermissionServiceEventImpl;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.kyori.event.EventBus;

public final class PermissionsModule
implements ImpactorModule {
    @Override
    public void subscribe(EventBus<ImpactorEvent> bus) {
        bus.subscribe(SuggestPermissionServiceEvent.class, event -> {
            PluginMetadata metadata = BaseImpactorPlugin.instance().metadata();
            event.suggest(metadata, ignore -> true, NoOpPermissionsService::new, 0);
            event.suggest(metadata, info -> info.plugin("luckperms").isPresent(), LuckPermsPermissionsService::new, 10);
        });
    }

    @Override
    public void init(Impactor impactor, PluginLogger logger) throws Exception {
        logger.info("Calculating permissions service...");
        SuggestPermissionServiceEventImpl event = new SuggestPermissionServiceEventImpl();
        impactor.events().post((Object)event);
        PermissionsRegistrationProvider.PermissionServiceSuggestion suggestion = event.provider().suggestion();
        PermissionsService service = suggestion.supplier().get();
        logger.info("Permissions \u00bb Selected \"" + service.name() + "\" (Provider: " + suggestion.metadata().name().orElse(suggestion.metadata().id()) + ", Priority = " + suggestion.priority() + ")");
    }
}

